#!/bin/sh

echo "+++++ Checking current user rights..."

if [ "$(id -u root)" = "$(id -u)" ] ; then
    echo "Passed..."
else
    echo "ERROR: The current user id is not root (`id|awk '{print $1}'`)."
    exit 1
fi
echo

if [ "X$ACTIANZEN_ROOT" = "X" ] ; then
    ACTIANZEN_ROOT=/usr/local/actianzen
fi

LIBDIR=lib64

PATH=$ACTIANZEN_ROOT/bin:$PATH
if [ $(uname -s) = "Darwin" ]
then
    DYLD_LIBRARY_PATH=$ACTIANZEN_ROOT/bin:$ACTIANZEN_ROOT/lib:$ACTIANZEN_ROOT/lib64:$DYLD_LIBRARY_PATH
    export DYLD_LIBRARY_PATH
    SO_EXTENSION="dylib"
else
    LD_LIBRARY_PATH=$ACTIANZEN_ROOT/bin:$ACTIANZEN_ROOT/$LIBDIR:$LD_LIBRARY_PATH
    SO_EXTENSION="so"
fi

# PSQL-6812 - v14 or later incompatible with v13 and earlier.
echo "+++++ Checking for previous installs..."
if [ -f /usr/local/psql/lib64/libpsqlmif.${SO_EXTENSION} ] ; then
    echo "ERROR: An incompatible version of PSQL is currently installed.  Please uninstall the incompatible version before installing Zen."
    exit 1
fi
echo "Passed..."
echo

# PSQL-6981 - Cannot install v14 or later if legacy username is running any process.
echo "+++++ Checking for running processes owned by user 'psql'..."
PROC_LIST_HEADERS=`ps -ef | head -n1`
LEGACY_OWNER_PROCS=`ps -fu psql 2>/dev/null | grep psql | grep -v grep`
if [ "X$LEGACY_OWNER_PROCS" != "X" ] ; then
    echo "ERROR: One or more processes owned by user 'psql' is currently running. Please stop all processes owned by user 'psql' prior to installing Zen."
    echo "Running processes owned by user 'psql':"
    echo "$PROC_LIST_HEADERS"
    echo "$LEGACY_OWNER_PROCS"
    echo
    exit 1
fi
echo "Passed..."
echo

if [ $(uname -s) != "Darwin" ]
then
    echo "+++++ Checking for system dependencies..."

    # PSQL-8641: Remove use of 'file -L'. Makefile updates placeholder tags
    # dynamically at build time.
    if [ ! -e "/lib/ld-linux-aarch64.so.1" ] && [ ! -e "/lib64/ld-linux-aarch64.so.1" ]; then
        echo "ERROR: ld-linux-aarch64.so.1 not found. This package requires this version of ld-linux."
        exit 1
    fi
fi

echo "Passed..."
echo
