/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.ParamDesc;
import com.pervasive.jdbc.lna.ParamDescSet;
import com.pervasive.jdbc.lna.ParamInfo;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public final class ParamInfoSet {
    private Vector d_items;

    public ParamInfoSet() {
        this.d_items = new Vector();
    }

    public ParamInfoSet(ParamDescSet paramDescSet) {
        int n = paramDescSet.getCount();
        this.d_items = new Vector();
        for (int i = 0; i < n; ++i) {
            this.d_items.add(new ParamInfo(paramDescSet.getItem(i), (short)(i + 1), 0));
        }
    }

    public void addParamDesc(ParamDesc paramDesc, short s, short s2, Object object, int n) {
        ParamInfo paramInfo = new ParamInfo(paramDesc, s, s2);
        paramInfo.setValue(object);
        paramInfo.setIndicator(n);
        this.d_items.add(paramInfo);
    }

    public void addParamDesc(ParamDesc paramDesc, short s, short s2, Object object) {
        this.addParamDesc(paramDesc, s, s2, object, 0);
    }

    public int getCount() {
        return this.d_items != null ? this.d_items.size() : 0;
    }

    public ParamInfo getItem(int n) {
        return (ParamInfo)this.d_items.elementAt(n);
    }

    public Object getObject(int n) throws SQLException {
        if (n < 1 || n > this.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_PARAM_NUM, "S1093", 0);
        }
        return this.getItem(n - 1).getValue();
    }

    public void readFrom(LNAResponse lNAResponse) throws IOException {
        int n = lNAResponse.readInt();
        for (int i = 0; i < n; ++i) {
            this.readParamBlockFrom(lNAResponse);
        }
    }

    public void writeTo(LNARequest lNARequest) throws IOException {
        this.writeParamBlockTo(lNARequest, (short)4);
        this.writeParamBlockTo(lNARequest, (short)1);
    }

    public void writeDataAtExecParams(LNARequest lNARequest) throws IOException {
        int n = this.countParams((short)4);
        lNARequest.writeShort((short)n);
        lNARequest.writeInt(n == 0 ? -1 : n);
        for (int i = 0; i < this.getCount(); ++i) {
            ParamInfo paramInfo = this.getItem(i);
            if (paramInfo.getParamType() == 4) continue;
            paramInfo.writeDataAtExec(lNARequest);
        }
    }

    public void setInParameter(int n, Object object) throws SQLException {
        ParamInfo paramInfo;
        if (n < 1 || n > this.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_PARAM_NUM, "S1093", 0);
        }
        paramInfo.setParamType((paramInfo = this.getItem(n - 1)).getParamType() == 4 ? (short)2 : 1);
        paramInfo.setValue(object);
    }

    public void clearParameterValues() {
        if (this.d_items != null) {
            for (int i = 0; i < this.d_items.size(); ++i) {
                this.getItem(i).setValue(null);
            }
        }
    }

    public void setInParameter(int n, Object object, int n2, int n3) throws SQLException {
        ParamInfo paramInfo;
        if (n < 1 || n > this.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_PARAM_NUM, "S1093", 0);
        }
        paramInfo.setParamType((paramInfo = this.getItem(n - 1)).getParamType() == 4 ? (short)2 : 1);
        paramInfo.setDataType((short)n2);
        paramInfo.setScale((short)n3);
        paramInfo.setValue(object);
    }

    public ParamInfo registerOutParameter(int n, short s) throws SQLException {
        if (n < 1 || n > this.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_PARAM_NUM, "S1093", 0);
        }
        ParamInfo paramInfo = this.getItem(n - 1);
        if (paramInfo.getParamType() == 1) {
            paramInfo.setParamType((short)2);
        } else {
            paramInfo.setParamType((short)4);
            paramInfo.setValue(null);
        }
        paramInfo.setDataType(s);
        return paramInfo;
    }

    private void readParamBlockFrom(LNAResponse lNAResponse) throws IOException {
        lNAResponse.readShort();
        int n = lNAResponse.readInt();
        if (n < 0) {
            n = 0;
        }
        if (this.d_items == null) {
            this.d_items = new Vector();
        }
        ParamInfo paramInfo = new ParamInfo();
        for (int i = 0; i < n; ++i) {
            paramInfo.readFrom(lNAResponse);
            short s = paramInfo.getParamNum();
            if (s <= 0 || s > this.getCount()) {
                throw new IOException(LocalStrings.ERR_SQL_INVALID_PARAM_NUM);
            }
            ParamInfo paramInfo2 = this.getItem(s - 1);
            paramInfo2.setValue(paramInfo.getValue());
        }
    }

    private void writeParamBlockTo(LNARequest lNARequest, short s) throws IOException {
        int n = this.countParams(s);
        lNARequest.writeShort((short)n);
        lNARequest.writeInt(n == 0 ? -1 : n);
        for (int i = 0; i < this.getCount(); ++i) {
            ParamInfo paramInfo = this.getItem(i);
            if (paramInfo.getParamType() == s) continue;
            paramInfo.writeTo(lNARequest);
        }
    }

    private int countParams(short s) {
        int n = 0;
        for (int i = 0; i < this.getCount(); ++i) {
            ParamInfo paramInfo = this.getItem(i);
            if (paramInfo.getParamType() == s) continue;
            ++n;
        }
        return n;
    }
}

