/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import pervasive.database.CharsetUtils;
import pervasive.database.DBURI;
import pervasive.database.DBUtil;
import pervasive.database.Driver;
import pervasive.database.IBTRV;
import pervasive.database.JNIBTRV;
import pervasive.database.MessageCatalog;
import pervasive.database.PsqlException;
import pervasive.database.PsqlInvalidObjectException;
import pervasive.database.PsqlOperationException;
import pervasive.database.PsqlUnsupportedEncodingException;
import pervasive.database.SCursor;
import pervasive.database.Session;
import pervasive.database.Table;
import pervasive.database.XCursor;

public class Database {
    public static final String BTRV_PROTOCOL = "btrv";
    private boolean m_objClosed = false;
    private Session m_parent;
    String[] m_tableNames;
    Hashtable m_tables = new Hashtable();
    String m_dataPath = "";
    Vector m_cursors = new Vector();
    private IBTRV m_btrv = null;
    private SCursor m_cursor = null;
    private DBURI m_uri;
    private String m_charsetName = Driver.defaultCharsetName;
    private boolean m_logout = false;
    private String[] m_dataPathStrs = new String[]{""};

    Database(Session session, String string) throws PsqlException {
        this.m_parent = session;
        this.m_uri = new DBURI(string);
        this.m_btrv = new JNIBTRV(this.m_uri);
        this.m_cursor = new SCursor(this, this.m_btrv, 64128, 255, this.m_charsetName);
        this.m_cursors.addElement(this.m_cursor);
        try {
            String string2 = this.m_uri.getDBName();
            if (string2 != null && string2.length() > 0) {
                DBUtil.login(this.m_cursor, this.m_uri);
                this.m_logout = true;
                this.m_dataPath = this.m_btrv.getDataPath(string2);
                this.m_dataPathStrs = this.enumDataPaths(this.m_dataPath);
            }
        }
        catch (PsqlException psqlException) {
            this.close();
            throw psqlException;
        }
    }

    public String getDataPath() {
        return this.m_dataPath;
    }

    public DBURI getDatabaseURI() {
        return this.m_uri;
    }

    public Session getSession() {
        return this.m_parent;
    }

    public String[] getTableNames() throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        if (this.m_tableNames != null) {
            return this.m_tableNames;
        }
        this.getDatabaseTableInfo(true);
        return this.m_tableNames;
    }

    public void setCharsetName(String string) throws PsqlUnsupportedEncodingException {
        if (!CharsetUtils.isSupportedCharsetName(string)) {
            throw new PsqlUnsupportedEncodingException(string);
        }
        this.m_charsetName = string;
    }

    public String getCharsetName() {
        return this.m_charsetName;
    }

    public Table getTable(String string) throws PsqlException {
        return this.getTable(string, null);
    }

    public Table getTable(String string, String string2) throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        if (this.m_tables.containsKey(string)) {
            return (Table)this.m_tables.get(string);
        }
        if (this.m_tableNames == null) {
            this.getTableNames();
        }
        Table table = new Table(this, string, string2, this.m_dataPathStrs, this.m_charsetName, this.m_btrv);
        this.m_tables.put(string, table);
        return table;
    }

    public SCursor createSCursor(int n) {
        return this.createSCursor(n, 255, 0);
    }

    public SCursor createSCursor(int n, int n2) {
        return this.createSCursor(n, n2, 0);
    }

    public SCursor createSCursor(int n, int n2, int n3) {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        SCursor sCursor = new SCursor(this, this.m_btrv, n, n2, this.m_charsetName);
        sCursor.setKeyNumber(n3);
        this.m_cursors.addElement(sCursor);
        return sCursor;
    }

    public XCursor createXCursor(int n) {
        return this.createXCursor(n, 255, 0);
    }

    public XCursor createXCursor(int n, int n2) {
        return this.createXCursor(n, n2, 0);
    }

    public XCursor createXCursor(int n, int n2, int n3) {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        XCursor xCursor = new XCursor(this, this.m_btrv, n, n2, this.m_charsetName);
        xCursor.setKeyNumber(n3);
        this.m_cursors.addElement(xCursor);
        return xCursor;
    }

    public void close() {
        if (this.m_objClosed) {
            return;
        }
        Enumeration enumeration = this.m_tables.elements();
        while (enumeration.hasMoreElements()) {
            Table table = (Table)enumeration.nextElement();
            table.close();
        }
        for (int i = this.m_cursors.size() - 1; i >= 0; --i) {
            ((SCursor)this.m_cursors.lastElement()).close();
        }
        this.m_parent.childClosed(this);
        if (this.m_uri != null && this.m_logout) {
            try {
                DBUtil.logout(this, this.m_uri);
            }
            catch (PsqlException psqlException) {
                // empty catch block
            }
        }
        if (this.m_btrv != null) {
            this.m_btrv.close();
            this.m_btrv = null;
        }
        this.m_objClosed = true;
    }

    boolean isClosed() {
        return this.m_objClosed;
    }

    void childClosed(Table table) {
    }

    void childClosed(SCursor sCursor) {
        this.m_cursors.removeElement(sCursor);
    }

    void beginTransaction(int n) throws PsqlException {
        this.makeBTRVCall(19 + n);
    }

    void endTransaction() throws PsqlException {
        this.makeBTRVCall(20);
    }

    void abortTransaction() throws PsqlException {
        this.makeBTRVCall(21);
    }

    private void makeBTRVCall(int n) throws PsqlException {
        int n2 = this.m_cursor.BTRV(n);
        if (n2 > 0) {
            throw new PsqlOperationException(n, n2, MessageCatalog.getTransactionMsg());
        }
    }

    private void getDatabaseTableInfo(boolean bl) throws PsqlException {
        this.m_tableNames = this.m_btrv.getTableNames();
    }

    private String[] enumDataPaths(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"));
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string2 = stringTokenizer.nextToken();
            char c = string2.charAt(string2.length() - 1);
            stringArray[i] = c != '\\' && c != '/' ? string2 + System.getProperty("file.separator") : string2;
        }
        return stringArray;
    }
}

