/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.io.IOException;
import java.io.InputStream;
import pervasive.database.Buffer;

class DBObjectInputStream
extends InputStream {
    private Buffer _row;
    private int _columnNumber;
    private int _idx = 0;

    DBObjectInputStream(Buffer buffer, int n) {
        this._row = buffer;
        this._columnNumber = n;
    }

    @Override
    public int read() throws IOException {
        int n = 0;
        try {
            byte[] byArray = this._row.getBytes(this._columnNumber, this._idx++, 1);
            n = byArray[0];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
        return n &= 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = null;
        try {
            byArray2 = this._row.getBytes(this._columnNumber, this._idx, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        this._idx += byArray2.length;
        return byArray2.length;
    }

    @Override
    public int available() throws IOException {
        return super.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
    }
}

