/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.util.Enumeration;
import java.util.StringTokenizer;
import pervasive.database.BufferMetaData;
import pervasive.database.ColumnDef;
import pervasive.database.Consts;
import pervasive.database.DBURI;
import pervasive.database.DBUtil;
import pervasive.database.Database;
import pervasive.database.FieldDef;
import pervasive.database.MessageCatalog;
import pervasive.database.PsqlComparisonNotSupportedException;
import pervasive.database.PsqlEOFException;
import pervasive.database.PsqlException;
import pervasive.database.PsqlIOException;
import pervasive.database.PsqlInvalidFilterException;
import pervasive.database.PsqlNull;
import pervasive.database.RowSet;
import pervasive.database.SCursor;
import pervasive.database.Table;
import pervasive.database.TableMetaData;
import pervasive.database.Term;
import pervasive.database.XCursor;

public class RowSetMetaData
extends BufferMetaData
implements Consts {
    int m_access = 0;
    int m_lockmode;
    int m_direction = 1;
    short m_numins = 1;
    short m_numget = 1;
    TableMetaData m_tmeta;
    RowSet m_parent;
    boolean fullrow = false;
    private XCursor m_cursor;

    RowSetMetaData(RowSet rowSet, boolean bl, XCursor xCursor) {
        super(rowSet.getTable());
        this.m_parent = rowSet;
        this.m_cursor = xCursor;
        this.m_tmeta = rowSet.m_parent.m_meta;
        if (bl) {
            return;
        }
        this.addAllColumns();
    }

    public void setLockMode(int n) {
        this.m_lockmode = n;
    }

    public int getLockMode() {
        return this.m_lockmode;
    }

    public void setAccessPath(String string) throws PsqlIOException {
        int n = this.m_parent.m_parent.m_meta.findIndex(string);
        if (n == -1) {
            throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "setAccessPath", "indName", string));
        }
        this.setAccessPath(n);
    }

    public void setAccessPath(int n) throws PsqlIOException {
        if (this.m_access != n && n != 999) {
            try {
                this.m_parent.changeAccessPath(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "setAccessPath", "indNum", Integer.toString(n)));
            }
        }
        this.m_access = n;
    }

    public int getAccessPath() {
        return this.m_access;
    }

    public void setDirection(int n) {
        this.m_direction = n;
    }

    public int getDirection() {
        return this.m_direction;
    }

    public void setCountForRetrieval(short s) {
        if (s != this.m_numget) {
            this.m_parent.setNumberOfRows(s);
            this.m_parent.m_curind = -1;
            this.m_numget = s;
        }
    }

    public short getCountForRetrieval() {
        return this.m_numget;
    }

    public void addColumns(String string) {
        this.m_parent.m_exops = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.addClone(this.m_tmeta.getColumnDef(stringTokenizer.nextToken()));
        }
        this.setFieldsToParent();
    }

    public void addColumns(String[] stringArray) {
        this.m_parent.m_exops = false;
        for (int i = 0; i < stringArray.length; ++i) {
            this.addClone(this.m_tmeta.getColumnDef(stringArray[i]));
        }
        this.setFieldsToParent();
    }

    public void addColumns(int[] nArray) {
        this.m_parent.m_exops = false;
        for (int i = 0; i < nArray.length; ++i) {
            this.addClone(this.m_tmeta.getColumnDef(nArray[i]));
        }
        this.setFieldsToParent();
    }

    public void dropColumns(String string) {
        this.m_parent.m_exops = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.removeColumnDef(stringTokenizer.nextToken());
        }
        this.setFieldsToParent();
    }

    public void dropColumns(String[] stringArray) {
        this.m_parent.m_exops = false;
        for (int i = 0; i < stringArray.length; ++i) {
            this.removeColumnDef(stringArray[i]);
        }
        this.setFieldsToParent();
    }

    void setFieldsToParent() {
        this.m_parent.m_curind = -1;
        this.m_cursor.m_currFields = 0;
        this.fullrow = false;
        Enumeration enumeration = this.m_vcol.elements();
        while (enumeration.hasMoreElements()) {
            ColumnDef columnDef = (ColumnDef)enumeration.nextElement();
            if (columnDef.isNullable()) {
                int n = columnDef.getOffset() - 1;
                FieldDef fieldDef = new FieldDef(n, 0, 1);
                this.m_cursor.addField(fieldDef);
            }
            this.m_cursor.addField(columnDef);
        }
        this.m_parent.setNumberOfRows(this.m_numget);
    }

    public void dropAllColumns() {
        this.m_vcol.removeAllElements();
        this.m_hcol.clear();
        this.m_highoffs = 0;
        this.m_cursor.dropAllFields();
        this.m_parent.m_curind = -1;
        this.fullrow = false;
    }

    public void addFirstTerm(ColumnDef columnDef, byte by, ColumnDef columnDef2) {
        this.m_cursor.addFirstTerm((FieldDef)columnDef, by, columnDef2);
        if (columnDef.isNullable()) {
            this.addAndTerm(columnDef, (byte)4, PsqlNull.instance);
        }
        if (columnDef2.isNullable()) {
            this.addAndTerm(columnDef2, (byte)4, PsqlNull.instance);
        }
    }

    public void addFirstTerm(ColumnDef columnDef, byte by, String string) {
        this.m_cursor.addFirstTerm((FieldDef)columnDef, by, string);
        if (columnDef.isNullable()) {
            this.addAndTerm(columnDef, (byte)4, PsqlNull.instance);
        }
    }

    public void addFirstTerm(ColumnDef columnDef, byte by, PsqlNull psqlNull) {
        if (by != 1 && by != 4) {
            throw new PsqlComparisonNotSupportedException(MessageCatalog.getComparisonNotSupportedMsg());
        }
        int n = columnDef.getOffset() - 1;
        FieldDef fieldDef = new FieldDef(n, 0, 1);
        by = by == 1 ? (byte)4 : (byte)1;
        char[] cArray = new char[]{'\u0000'};
        this.m_cursor.addFirstTerm(fieldDef, by, new String(cArray));
    }

    public void addAndTerm(ColumnDef columnDef, byte by, ColumnDef columnDef2) {
        if (columnDef.isNullable() || columnDef2.isNullable()) {
            throw new PsqlInvalidFilterException(MessageCatalog.getInvalidFilterMsg());
        }
        this.m_cursor.addAndTerm((FieldDef)columnDef, by, columnDef2);
    }

    public void addAndTerm(ColumnDef columnDef, byte by, String string) {
        if (columnDef.isNullable()) {
            throw new PsqlInvalidFilterException(MessageCatalog.getInvalidFilterMsg());
        }
        this.m_cursor.addAndTerm((FieldDef)columnDef, by, string);
    }

    private void addAndTerm(ColumnDef columnDef, byte by, PsqlNull psqlNull) {
        if (by != 1 && by != 4) {
            throw new PsqlComparisonNotSupportedException(MessageCatalog.getComparisonNotSupportedMsg());
        }
        int n = columnDef.getOffset() - 1;
        FieldDef fieldDef = new FieldDef(n, 0, 1);
        by = by == 1 ? (byte)4 : (byte)1;
        char[] cArray = new char[]{'\u0000'};
        this.m_cursor.addAndTerm(fieldDef, by, new String(cArray));
    }

    public void addOrTerm(ColumnDef columnDef, byte by, ColumnDef columnDef2) {
        if (columnDef.isNullable() || columnDef2.isNullable()) {
            throw new PsqlInvalidFilterException(MessageCatalog.getInvalidFilterMsg());
        }
        this.m_cursor.addOrTerm((FieldDef)columnDef, by, columnDef2);
    }

    public void addOrTerm(ColumnDef columnDef, byte by, String string) {
        if (columnDef.isNullable()) {
            throw new PsqlInvalidFilterException(MessageCatalog.getInvalidFilterMsg());
        }
        this.m_cursor.addOrTerm((FieldDef)columnDef, by, string);
    }

    public void dropAllTerms() {
        this.m_cursor.dropAllTerms();
    }

    public void addAllColumns() {
        this.dropAllColumns();
        for (int i = 0; i < this.m_tmeta.m_vcol.size(); ++i) {
            this.addClone((ColumnDef)this.m_tmeta.m_vcol.elementAt(i));
        }
        this.fullrow = true;
        this.m_parent.m_curind = -1;
        this.m_cursor.m_currFields = 0;
        this.m_cursor.addField(new ColumnDef("ALL_FIELDS", 0, 0, this.m_tmeta.m_highoffs, 0, false, false));
    }

    public int getRowCount() throws PsqlException {
        Term[] termArray = this.m_cursor.getTerms();
        RowSet rowSet = null;
        int n = 0;
        try {
            if (termArray == null) {
                n = this.getRowCountFromStat();
                if (n != -1) {
                    return n;
                }
                n = 0;
            }
            rowSet = this.m_parent.m_parent.createRowSet(true);
            if (termArray != null) {
                String[] stringArray = new String[termArray.length];
                for (int i = 0; i < termArray.length; ++i) {
                    stringArray[i] = ((ColumnDef)termArray[i].getFieldDef()).getColumnName();
                }
                rowSet.getRowSetMetaData().addColumns(stringArray);
                rowSet.getCursor().setTerms(termArray);
            }
            while (true) {
                rowSet.getNext();
                ++n;
            }
        }
        catch (PsqlEOFException psqlEOFException) {
        }
        catch (PsqlException psqlException) {
            if (rowSet != null) {
                rowSet.close();
            }
            throw psqlException;
        }
        rowSet.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRowCountFromStat() throws PsqlIOException {
        Table table = this.m_parent.m_parent;
        Database database = table.m_parent;
        int n = -1;
        try (SCursor sCursor = database.createSCursor(0);){
            DBURI dBURI = DBURI.createTableURI(database.getDatabaseURI().getHost(), database.getDatabaseURI().getDBName(), table.m_tname);
            try {
                DBUtil.openDBResource(sCursor, dBURI, table.m_owner);
            }
            catch (PsqlException psqlException) {
                int n2 = -1;
                sCursor.close();
                return n2;
            }
            sCursor.setDataSize(2000);
            sCursor.setKeySize(10);
            sCursor.setKeyNumber(0);
            int n3 = sCursor.BTRV(15);
            if (n3 > 0) {
                int n4 = -1;
                return n4;
            }
            n = sCursor.getDInt4(6);
        }
        return n;
    }
}

