/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.v2;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.common.ObjectConverter;
import com.pervasive.jdbc.lna.ArrayFetchResultCache;
import com.pervasive.jdbc.lna.ColumnInfo;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.ForwardReadResultCache;
import com.pervasive.jdbc.lna.InsensitiveResultCache;
import com.pervasive.jdbc.lna.LNAConnection;
import com.pervasive.jdbc.lna.LNAStatement;
import com.pervasive.jdbc.lna.ResultCache;
import com.pervasive.jdbc.lna.SensitiveResultCache;
import com.pervasive.jdbc.lna.SingleFetchResultCache;
import com.pervasive.jdbc.lna.StatementOptions;
import com.pervasive.jdbc.v2.Connection;
import com.pervasive.jdbc.v2.ResultSetMetaData;
import com.pervasive.jdbc.v2.Statement;
import com.pervasive.util.convert.CalendarConverter;
import com.pervasive.util.convert.ConversionException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class ResultSet
implements java.sql.ResultSet {
    private static final int MAX_FETCH_SIZE = 1000;
    private Statement d_stmt;
    private ColumnInfoSet d_cis;
    private int d_type;
    private int d_concurrency;
    private ResultCache d_cache;
    private LNAConnection d_lnaConn;
    private boolean d_canScroll;
    private boolean d_wasNull;
    private ResultSetMetaData d_metaData;
    private String d_sql;

    ResultSet(Statement statement, ColumnInfoSet columnInfoSet, String string) throws SQLException {
        this.d_stmt = statement;
        this.d_cis = columnInfoSet;
        this.d_sql = string;
        LNAStatement lNAStatement = statement.getLNAStatement();
        this.d_lnaConn = ((Connection)statement.getConnection()).getLNAConnection();
        this.d_canScroll = lNAStatement.scrollCapable();
        this.assignStatementType(lNAStatement);
        this.createResultCache(lNAStatement, true, false);
    }

    ResultSet(Statement statement, ColumnInfoSet columnInfoSet, ResultCache resultCache) throws SQLException {
        this.d_stmt = statement;
        this.d_cis = columnInfoSet;
        this.d_cache = resultCache;
        LNAStatement lNAStatement = statement.getLNAStatement();
        this.d_lnaConn = ((Connection)statement.getConnection()).getLNAConnection();
        this.d_canScroll = lNAStatement.scrollCapable();
        this.assignStatementType(lNAStatement);
        this.openResultCache(lNAStatement);
    }

    ResultSet(ColumnInfoSet columnInfoSet, LNAStatement lNAStatement) throws SQLException {
        this(columnInfoSet, lNAStatement, false);
    }

    ResultSet(ColumnInfoSet columnInfoSet, LNAStatement lNAStatement, boolean bl) throws SQLException {
        this.d_cis = columnInfoSet;
        this.d_lnaConn = lNAStatement.getLNAConnection();
        this.d_canScroll = lNAStatement.scrollCapable();
        this.assignStatementType(lNAStatement);
        this.createResultCache(lNAStatement, true, bl);
    }

    ResultSet(LNAConnection lNAConnection, ColumnInfoSet columnInfoSet, ResultCache resultCache, int n, int n2) throws SQLException {
        this.d_lnaConn = lNAConnection;
        this.d_cis = columnInfoSet;
        this.d_type = n;
        this.d_concurrency = n2;
        this.d_cache = resultCache;
        this.d_cache.open();
    }

    private boolean isSQLWChar(int n) {
        ColumnInfo columnInfo = this.d_cis.getItem(n - 1);
        return columnInfo.getDataType() == -8 || columnInfo.getDataType() == -9 || columnInfo.getDataType() == -10;
    }

    private void assignStatementType(LNAStatement lNAStatement) {
        StatementOptions statementOptions = lNAStatement.getStmtOpts();
        int n = statementOptions.getCursorType();
        int n2 = statementOptions.getConcurrency();
        switch (n) {
            case 0: {
                this.d_type = 1003;
                break;
            }
            case 3: {
                this.d_type = 1004;
                break;
            }
            default: {
                this.d_type = 1005;
            }
        }
        this.d_concurrency = n2 == 1 ? 1007 : 1008;
    }

    private void createResultCache(LNAStatement lNAStatement, boolean bl, boolean bl2) throws SQLException {
        int n;
        int n2 = n = this.d_stmt != null ? this.d_stmt.getFetchDirection() : 1003;
        if (this.d_canScroll) {
            if (this.d_type == 1003 && this.d_concurrency == 1007) {
                this.d_cache = new ForwardReadResultCache(lNAStatement, this.d_cis, bl2);
            } else {
                boolean bl3;
                boolean bl4 = bl3 = this.d_concurrency == 1008;
                this.d_cache = this.d_type == 1005 ? new SensitiveResultCache(lNAStatement, this.d_cis, bl3) : new InsensitiveResultCache(lNAStatement, this.d_cis, bl3, n, this.d_sql);
            }
        } else {
            this.d_cache = bl ? new ArrayFetchResultCache(lNAStatement, this.d_cis) : new SingleFetchResultCache(lNAStatement, this.d_cis);
        }
        this.openResultCache(lNAStatement);
    }

    private void openResultCache(LNAStatement lNAStatement) throws SQLException {
        this.d_cache.open();
        if (this.d_cache instanceof ArrayFetchResultCache && ((ArrayFetchResultCache)this.d_cache).isDisabled()) {
            this.d_cache.close();
            this.d_cache = null;
            this.createResultCache(lNAStatement, false, false);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void close() throws SQLException {
        this.d_cache.close();
        if (this.d_stmt != null) {
            this.d_stmt.resultSetClosed();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.d_wasNull;
    }

    @Override
    public String getString(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            String string = this.d_wasNull ? null : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE") : com.pervasive.util.convert.ObjectConverter.convertString(object, this.d_lnaConn.getEncoding()));
            return string;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            boolean bl2 = this.d_wasNull ? false : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertBoolean(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertBoolean(object));
            return bl2;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public byte getByte(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            byte by = this.d_wasNull ? (byte)0 : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertByte(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertByte(object));
            return by;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public short getShort(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            short s = this.d_wasNull ? (short)0 : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertShort(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertShort(object));
            return s;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public int getInt(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            int n2 = this.d_wasNull ? 0 : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertInt(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertInt(object));
            return n2;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public long getLong(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            long l = this.d_wasNull ? 0L : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertLong(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertLong(object));
            return l;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public float getFloat(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            float f = this.d_wasNull ? 0.0f : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertFloat(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertFloat(object));
            return f;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public double getDouble(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            double d = this.d_wasNull ? 0.0 : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertDouble(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertDouble(object));
            return d;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n).setScale(n2, 4);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            this.d_wasNull = object == null;
            return this.d_wasNull ? null : com.pervasive.util.convert.ObjectConverter.convertBytes(object);
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public Date getDate(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            Date date = this.d_wasNull ? null : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertDate(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertDate(object));
            return date;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public Time getTime(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            Time time = this.d_wasNull ? null : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertTime(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertTime(object));
            return time;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            Timestamp timestamp = this.d_wasNull ? null : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertTimestamp(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertTimestamp(object));
            return timestamp;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            InputStream inputStream = this.d_wasNull ? null : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertAsciiStream(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertAsciiStream(object));
            return inputStream;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            this.d_wasNull = object == null;
            return this.d_wasNull ? null : com.pervasive.util.convert.ObjectConverter.convertUnicodeStream(object);
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            this.d_wasNull = object == null;
            return this.d_wasNull ? null : com.pervasive.util.convert.ObjectConverter.convertBinaryStream(object);
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.d_stmt == null) {
            return null;
        }
        return (SQLWarning)this.d_stmt.getLNAStatement().getErrors(true);
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.d_stmt == null) {
            return;
        }
        this.d_stmt.getLNAStatement().clearErrors();
    }

    @Override
    public String getCursorName() throws SQLException {
        if (this.d_stmt == null) {
            return null;
        }
        return this.d_stmt.getLNAStatement().getCursorName();
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.d_metaData == null) {
            this.d_metaData = new ResultSetMetaData(this.d_lnaConn, this.d_cis);
        }
        return this.d_metaData;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            try {
                switch (this.d_cis.getItem(n - 1).getDataType()) {
                    case -4: {
                        return com.pervasive.util.convert.ObjectConverter.convertBytes(object);
                    }
                    case -10: {
                        return com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE");
                    }
                }
                return com.pervasive.util.convert.ObjectConverter.convertString(object, this.d_lnaConn.getEncoding());
            }
            catch (ConversionException conversionException) {
                throw new SQLException(conversionException.toString());
            }
        }
        ColumnInfo columnInfo = this.d_cis.getItem(n - 1);
        switch (columnInfo.getDataType()) {
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 2: {
                return this.getBigDecimal(n, (int)columnInfo.getScale());
            }
            case 3: {
                return this.getBigDecimal(n, (int)columnInfo.getScale());
            }
            case -5: {
                if (this.getMetaData().isSigned(n)) {
                    return new Long(this.getLong(n));
                }
                return new BigInteger(object.toString());
            }
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: 
            case 5: {
                return new Integer(this.getInt(n));
            }
            case 4: {
                if (this.getMetaData().isSigned(n)) {
                    return new Integer(this.getInt(n));
                }
                return new Long(this.getLong(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble(n));
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case 9: {
                return this.getDate(n);
            }
            case 10: {
                return this.getTime(n);
            }
            case 11: {
                return this.getTimestamp(n);
            }
        }
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public int findColumn(String string) throws SQLException {
        ColumnInfo columnInfo;
        int n;
        String string2 = null;
        String string3 = null;
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            string3 = string;
        } else {
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1);
        }
        int n3 = this.d_cis.getCount();
        for (n = 0; n < n3; ++n) {
            columnInfo = this.d_cis.getItem(n);
            if (!string3.equalsIgnoreCase(columnInfo.getColumnName()) || string2 != null && !string2.equalsIgnoreCase(columnInfo.getTableName())) continue;
            return n + 1;
        }
        for (n = 0; n < n3; ++n) {
            columnInfo = this.d_cis.getItem(n);
            if (!string3.equalsIgnoreCase(columnInfo.getColumnLabel())) continue;
            return n + 1;
        }
        throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NAME, "S1000", 0);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            Reader reader = this.d_wasNull ? null : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertCharacterStream(object, "UTF-16LE") : com.pervasive.util.convert.ObjectConverter.convertCharacterStream(object, this.d_lnaConn.getEncoding()));
            return reader;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.d_cache.getObject(n);
        try {
            boolean bl = this.d_wasNull = object == null;
            BigDecimal bigDecimal = this.d_wasNull ? null : (this.isSQLWChar(n) ? com.pervasive.util.convert.ObjectConverter.convertBigDecimal(com.pervasive.util.convert.ObjectConverter.convertString(object, "UTF-16LE")) : com.pervasive.util.convert.ObjectConverter.convertBigDecimal(object));
            return bigDecimal;
        }
        catch (ConversionException conversionException) {
            throw new SQLException(conversionException.toString());
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.d_cache.isRow(Integer.MIN_VALUE);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.d_cache.isRow(Integer.MAX_VALUE);
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.d_cache.isRow(1);
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.d_cache.isRow(-1);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.d_cache.absolute(Integer.MIN_VALUE);
    }

    @Override
    public void afterLast() throws SQLException {
        this.d_cache.absolute(Integer.MAX_VALUE);
    }

    @Override
    public boolean first() throws SQLException {
        return this.d_cache.absolute(1);
    }

    @Override
    public boolean last() throws SQLException {
        return this.d_cache.absolute(-1);
    }

    @Override
    public int getRow() throws SQLException {
        return this.d_cache.getRow();
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        return this.d_cache.absolute(n);
    }

    @Override
    public boolean relative(int n) throws SQLException {
        return this.d_cache.relative(n, false);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.d_cache.relative(-1, true);
    }

    @Override
    public boolean next() throws SQLException {
        return this.d_cache.relative(1, true);
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_FETCH_DIRECTION);
        }
        if (this.getType() == 1003 && n != 1000) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_FORWARD_ONLY_DIR);
        }
        this.d_cache.setFetchDirection(n);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.d_cache.getFetchDirection();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n < 0 || n > 1000) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_ROWSET_SIZE);
        }
        this.d_cache.setFetchSize(n);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.d_cache.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        return this.d_type;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.d_concurrency;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (this.d_concurrency != 1008) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        short s = this.d_cache.getRowStatus();
        return s == 2 || s == -1000;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (this.d_concurrency != 1008) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        return this.d_cache.getRowStatus() == 4;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.d_concurrency != 1008) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        return this.d_cache.getRowStatus() == 1;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.d_cache.updateObject(n, null);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, new Boolean(bl)));
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, new Byte(by)));
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, new Short(s)));
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, new Integer(n2)));
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, new Long(l)));
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, new Float(f)));
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, new Float(d)));
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, bigDecimal));
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, string));
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.d_cache.updateObject(n, byArray);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, date));
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, time));
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.d_cache.updateObject(n, this.convertObject(n, timestamp));
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.d_cache.updateObject(n, inputStream);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.d_cache.updateObject(n, inputStream);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.d_cache.updateObject(n, reader);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.d_cache.updateObject(n, object);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        if (this.d_concurrency != 1008) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (n < 1 || n > this.d_cis.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NUM, "S1002", 0);
        }
        this.d_cache.updateObject(n, object);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.d_cache.updateObject(this.findColumn(string), null);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        int n = this.findColumn(string);
        this.d_cache.updateObject(n, this.convertObject(n, new Boolean(bl)));
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        int n = this.findColumn(string);
        this.d_cache.updateObject(n, this.convertObject(n, new Byte(by)));
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        int n = this.findColumn(string);
        this.d_cache.updateObject(n, this.convertObject(n, new Short(s)));
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        int n2 = this.findColumn(string);
        this.d_cache.updateObject(n2, this.convertObject(n2, new Integer(n)));
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        int n = this.findColumn(string);
        this.d_cache.updateObject(n, this.convertObject(n, new Long(l)));
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        int n = this.findColumn(string);
        this.d_cache.updateObject(n, this.convertObject(n, new Float(f)));
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        int n = this.findColumn(string);
        this.d_cache.updateObject(n, this.convertObject(n, new Double(d)));
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        int n = this.findColumn(string);
        this.d_cache.updateObject(n, this.convertObject(n, bigDecimal));
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        int n = this.findColumn(string);
        this.d_cache.updateObject(n, this.convertObject(n, string2));
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.d_cache.updateObject(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        int n = this.findColumn(string);
        this.d_cache.updateObject(n, this.convertObject(n, date));
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        int n = this.findColumn(string);
        this.d_cache.updateObject(n, this.convertObject(n, time));
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        int n = this.findColumn(string);
        this.d_cache.updateObject(n, this.convertObject(n, timestamp));
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.d_cache.updateObject(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.d_cache.updateObject(this.findColumn(string), inputStream);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.d_cache.updateObject(this.findColumn(string), reader);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.d_cache.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.d_cache.updateObject(this.findColumn(string), object);
    }

    @Override
    public void insertRow() throws SQLException {
        this.d_cache.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.d_cache.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.d_cache.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.d_cache.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.d_cache.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.d_cache.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.d_cache.moveToCurrentRow();
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        return this.d_cache.getObject(n);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.d_cache.getObject(this.findColumn(string));
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return CalendarConverter.changeCalendar(this.getDate(n), calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return CalendarConverter.changeCalendar(this.getTime(n), calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return CalendarConverter.changeCalendar(this.getTimestamp(n), calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public java.sql.Statement getStatement() throws SQLException {
        return this.d_stmt;
    }

    private Object convertObject(int n, Object object) throws SQLException {
        short s = this.d_cis.getItem(n - 1).getDataType();
        short s2 = this.d_cis.getItem(n - 1).getBindType();
        int n2 = this.d_cis.getItem(n - 1).getPrecision();
        short s3 = this.d_cis.getItem(n - 1).getScale();
        return ObjectConverter.convertObject(object, s, s2, n2, s3);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.d_cache == null) {
            return true;
        }
        return this.d_cache.isClosed();
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        this.updateString(n, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateString(string, string2);
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(string);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(string);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(string, reader, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new SQLException(LocalStrings.ERR_VALUE_OUT_OF_RANGE);
        }
        this.updateCharacterStream(n, reader, (int)l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new SQLException(LocalStrings.ERR_VALUE_OUT_OF_RANGE);
        }
        this.updateCharacterStream(string, reader, (int)l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.d_cache.updateObject(n, reader);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(string, reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.d_cache.updateObject(this.findColumn(string), reader);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException(LocalStrings.ERR_NO_OBJECT_WRAPPED);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

