/*******************************************************************************
 * Copyright (c) 2000, 2004, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Ecplise Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Pervasive Software, Inc. - Added Dynamic properties
 *******************************************************************************/
package com.pervasive.open.eclipse.dynamicproperties;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPropertyPage;


/**
 * Implementers of this interface are able to provide propertypages dynamically, 
 * at runtime. This is useful in situations where the properties displayed are 
 * inherently context sensitive.
 */
public interface IDynamicPropertyPageContributor
{
    /**
     * Given an object, this method returns an array of string identifiers
     * representing the property pages available for the object. 
     * 
     * Supports hierarchical properties via the use of the parentId.
     * 
     * @param object the object for which properties are contributed
     * @param parentId the id of the parent page, if there is one
     * @return array of page identifiers
     */
    public String[] getPropertyPages(IAdaptable object, String parentId);    
    
    /**
     * Given a pageId, returns a string label.
     * 
     * @param pageId the id for the page whose name is returned
     * @return the string label
     */
    public String getLabel(String pageId);
    
    /**
     * Given a pageId, returns an image or null if none is available. 
     * @param pageId the id for the page whose image is returned
     * @return the image
     */
    public Image getImage(String pageId);
    
    /**
     * Given a pageId, creates and returns the proper IWorkbenchPropertyPage.
     * @param pageId the id for the page to create
     * @return the property page
     */
    public IWorkbenchPropertyPage createPage(String pageId);
}
