/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.io.EndianDataInputStream;
import com.pervasive.io.InterchangableByteArrayInputStream;
import com.pervasive.jdbc.common.CharacterEncoding;
import com.pervasive.jdbc.common.Encoding;
import com.pervasive.jdbc.lna.LNAPacket;
import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.util.misc.PTimestamp;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class LNAResponse
extends EndianDataInputStream
implements CharacterEncoding {
    private static final int MAX_ARRAY_SIZE = 256;
    private Encoding d_encoding;
    private LNAPacket d_lnaPacket;
    private boolean d_full = false;
    private Thread d_currentThread;
    private byte[] d_dataArray = new byte[256];
    private InterchangableByteArrayInputStream d_arrayStream = new InterchangableByteArrayInputStream(this.d_dataArray);
    private EndianDataInputStream d_dataIn = new EndianDataInputStream(this.d_arrayStream);

    public LNAResponse() {
        super(null);
        this.in = this.d_dataIn;
    }

    public int getFunction() {
        return this.d_lnaPacket.getFunction();
    }

    public short getRequestNumber() {
        return this.d_lnaPacket.getRequestNumber();
    }

    public short getReturnCode() {
        return this.d_lnaPacket.getReturnCode();
    }

    public long getReadTime() {
        return this.d_lnaPacket.getReadTime();
    }

    public DataInput getDataInput() {
        return (DataInput)((Object)this.in);
    }

    @Override
    public String getEncoding() {
        return this.d_encoding.toString();
    }

    @Override
    public Encoding getEncodingObject() {
        return this.d_encoding;
    }

    @Override
    public void setEncoding(String string) {
        this.d_encoding.setEncoding(string);
    }

    public void associateWithRequest(LNARequest lNARequest) {
        this.d_encoding = lNARequest.getEncodingObject();
    }

    public Time readTime() throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, this.readShort());
        calendar.set(12, this.readShort());
        calendar.set(13, this.readShort());
        return new Time(calendar.getTime().getTime());
    }

    public Date readDate() throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, this.readShort());
        calendar.set(2, this.readShort() - 1);
        calendar.set(5, this.readShort());
        return new Date(calendar.getTime().getTime());
    }

    public Timestamp readTimestamp() throws IOException {
        return this.readTimestamp(23, 0);
    }

    public Timestamp readTimestamp(int n, int n2) throws IOException {
        boolean bl = n != 23 || n2 != 0;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, this.readShort());
        calendar.set(2, this.readShort() - 1);
        calendar.set(5, this.readShort());
        short s = this.readShort();
        calendar.set(11, s);
        calendar.set(12, this.readShort());
        calendar.set(13, this.readShort());
        int n3 = this.readInt();
        if (!bl) {
            int n4 = n3 / 1000000;
            calendar.set(14, n4);
        }
        PTimestamp pTimestamp = new PTimestamp(calendar.getTime().getTime(), calendar.get(11) - s, n, n2);
        if (bl) {
            pTimestamp.setNanos(n3);
        }
        return pTimestamp;
    }

    public String readGUID(int n) throws IOException {
        byte[] byArray = this.readBytes(n);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(256 + (byArray[i] & 0xFF)).substring(1);
            stringBuffer.append(string.toUpperCase());
            if (i != 3 && i != 5 && i != 7 && i != 9) continue;
            stringBuffer.append('-');
        }
        return stringBuffer.toString();
    }

    public String readString() throws IOException {
        return this.readString(this.getEncoding());
    }

    public String readNullTermString() throws IOException {
        return this.readNullTermString(this.getEncoding());
    }

    public String readString(String string) throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return string == null ? new String(byArray) : new String(byArray, string);
    }

    public String readNullTermString(String string) throws IOException {
        String string2 = this.readString(string);
        int n = string2.indexOf(0);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public byte[] readBytes() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return byArray;
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public void readBytes(byte[] byArray, int n) throws IOException {
        this.readFully(byArray, 0, n);
    }

    public BigDecimal readBigDecimal() throws IOException {
        return new BigDecimal(this.readString("US-ASCII"));
    }

    public BigDecimal readNumeric(int n) throws IOException {
        byte[] byArray = this.readBytes(n);
        byte by = byArray[1];
        byte by2 = byArray[2];
        BigInteger bigInteger = BigInteger.valueOf((long)byArray[18] & 0xFFL).shiftLeft(120);
        BigInteger bigInteger2 = BigInteger.valueOf((long)byArray[17] & 0xFFL).shiftLeft(112);
        BigInteger bigInteger3 = BigInteger.valueOf((long)byArray[16] & 0xFFL).shiftLeft(104);
        BigInteger bigInteger4 = BigInteger.valueOf((long)byArray[15] & 0xFFL).shiftLeft(96);
        BigInteger bigInteger5 = BigInteger.valueOf((long)byArray[14] & 0xFFL).shiftLeft(88);
        BigInteger bigInteger6 = BigInteger.valueOf((long)byArray[13] & 0xFFL).shiftLeft(80);
        BigInteger bigInteger7 = BigInteger.valueOf((long)byArray[12] & 0xFFL).shiftLeft(72);
        BigInteger bigInteger8 = BigInteger.valueOf((long)byArray[11] & 0xFFL).shiftLeft(64);
        BigInteger bigInteger9 = BigInteger.valueOf((long)byArray[10] & 0xFFL).shiftLeft(56);
        BigInteger bigInteger10 = BigInteger.valueOf((long)byArray[9] & 0xFFL).shiftLeft(48);
        BigInteger bigInteger11 = BigInteger.valueOf((long)byArray[8] & 0xFFL).shiftLeft(40);
        BigInteger bigInteger12 = BigInteger.valueOf((long)byArray[7] & 0xFFL).shiftLeft(32);
        BigInteger bigInteger13 = BigInteger.valueOf((long)byArray[6] & 0xFFL).shiftLeft(24);
        BigInteger bigInteger14 = BigInteger.valueOf((long)byArray[5] & 0xFFL).shiftLeft(16);
        BigInteger bigInteger15 = BigInteger.valueOf((long)byArray[4] & 0xFFL).shiftLeft(8);
        BigInteger bigInteger16 = BigInteger.valueOf((long)byArray[3] & 0xFFL);
        BigInteger bigInteger17 = bigInteger.or(bigInteger2).or(bigInteger3).or(bigInteger4).or(bigInteger5).or(bigInteger6).or(bigInteger7).or(bigInteger8).or(bigInteger9).or(bigInteger10).or(bigInteger11).or(bigInteger12).or(bigInteger13).or(bigInteger14).or(bigInteger15).or(bigInteger16);
        BigDecimal bigDecimal = new BigDecimal(bigInteger17, by);
        if (by2 == 0) {
            return bigDecimal.negate();
        }
        return bigDecimal;
    }

    public void setPacket(LNAPacket lNAPacket) {
        this.d_lnaPacket = lNAPacket;
    }

    public synchronized boolean isFull() {
        return this.d_full;
    }

    public void setCurrentThread() {
        this.d_currentThread = Thread.currentThread();
    }

    public void interrupt() {
        if (this.d_currentThread == null) {
            return;
        }
        this.d_currentThread.interrupt();
    }

    public synchronized void reinit() {
        this.d_full = false;
    }

    public void readPacketData(InputStream inputStream) throws IOException {
        int n = this.d_lnaPacket.getPayloadSize();
        if (n > this.d_dataArray.length) {
            this.d_dataArray = new byte[n];
        } else if (n <= 256 && this.d_dataArray.length > 256) {
            this.d_dataArray = new byte[256];
        }
        int n2 = 0;
        for (int i = 0; i < n && (n2 = inputStream.read(this.d_dataArray, i, n - i)) != -1; i += n2) {
        }
        this.d_arrayStream.setByteArray(this.d_dataArray, 0, n);
        this.d_full = true;
    }
}

