/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.lna.LNAConnection;
import com.pervasive.jdbc.lna.LNAResponse;
import java.io.IOException;
import java.sql.SQLException;

public final class ConnectionOptions {
    private LNAConnection d_lnaConn;
    private int d_accessMode;
    private int d_autoCommit;
    private String d_currentQualifier;
    private int d_loginTimeout;
    private int d_packetSize;
    private int d_txnIsolation;
    private int d_cursors;

    public ConnectionOptions(LNAConnection lNAConnection) {
        this.d_lnaConn = lNAConnection;
    }

    public void readFrom(LNAResponse lNAResponse) throws IOException {
        this.d_accessMode = lNAResponse.readInt();
        this.d_autoCommit = lNAResponse.readInt();
        this.d_currentQualifier = lNAResponse.readString();
        this.d_loginTimeout = lNAResponse.readInt();
        this.d_packetSize = lNAResponse.readInt();
        this.d_txnIsolation = lNAResponse.readInt();
    }

    public int getAccessMode() {
        return this.d_accessMode;
    }

    public void setAccessMode(int n) throws SQLException {
        this.d_lnaConn.setConnOpt((short)101, n);
        this.d_accessMode = n;
    }

    public int getAutoCommit() {
        return this.d_autoCommit;
    }

    public void setAutoCommit(int n) throws SQLException {
        this.d_lnaConn.setConnOpt((short)102, n);
        this.d_autoCommit = n;
    }

    public String getCurrentQualifier() {
        return this.d_currentQualifier;
    }

    public void setCurrentQualifier(String string) throws SQLException {
        this.d_lnaConn.setConnOpt((short)109, string);
        this.d_currentQualifier = string;
    }

    public int getLoginTimeout() {
        return this.d_loginTimeout;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.d_lnaConn.setConnOpt((short)103, n);
        this.d_loginTimeout = n;
    }

    public int getPacketSize() {
        return this.d_packetSize;
    }

    public void setPacketSize(int n) throws SQLException {
        this.d_lnaConn.setConnOpt((short)112, n);
        this.d_packetSize = n;
    }

    public int getTxnIsolation() {
        return this.d_txnIsolation;
    }

    public void setTxnIsolation(int n) throws SQLException {
        this.d_lnaConn.setConnOpt((short)108, n);
        this.d_txnIsolation = n;
    }

    public int getCursors() throws SQLException {
        return this.d_lnaConn.getConnOpt((short)110);
    }

    public void setCursors(int n) throws SQLException {
        this.d_lnaConn.setConnOpt((short)110, n);
        this.d_cursors = n;
    }
}

