/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.ArrayColumnBuffer;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.FetchReader;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.LNAStatement;
import com.pervasive.jdbc.lna.ResultCache;
import java.io.IOException;
import java.sql.SQLException;

public final class ArrayFetchResultCache
implements ResultCache,
FetchReader {
    private static final int BUF_START = 1;
    private LNAStatement d_lnaStmt;
    private ColumnInfoSet d_cis;
    private boolean d_isClosed;
    private Object[][] d_fetchBuf;
    private int d_bufPos;
    private int d_bufCount;
    private int d_curRow;
    private int d_curFetchCol;
    private boolean d_eof;
    private boolean d_isLast;
    private boolean d_isDisabled;

    public ArrayFetchResultCache(LNAStatement lNAStatement) {
        this.d_lnaStmt = lNAStatement;
        this.d_isClosed = true;
    }

    public ArrayFetchResultCache(LNAStatement lNAStatement, ColumnInfoSet columnInfoSet) {
        this.d_lnaStmt = lNAStatement;
        this.d_cis = columnInfoSet;
        this.d_isClosed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void open() throws SQLException {
        if (this.d_isClosed) {
            this.d_isClosed = false;
            if (this.d_bufPos == this.d_bufCount && !this.d_isDisabled) {
                this.doFetch();
            }
            this.d_isLast = false;
            this.d_curRow = this.d_bufCount > 1 ? Integer.MIN_VALUE : 0;
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (!this.d_isClosed) {
            this.d_isClosed = true;
            this.freeBuffers();
            this.d_curRow = 0;
            if (!this.d_isDisabled) {
                this.d_lnaStmt.freeStmt((short)0);
            }
        }
    }

    @Override
    public final boolean isClosed() {
        return this.d_isClosed;
    }

    public final boolean isDisabled() {
        return this.d_isDisabled;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
    }

    @Override
    public int getRow() throws SQLException {
        return this.d_curRow;
    }

    @Override
    public boolean isRow(int n) throws SQLException {
        return n == -1 ? this.d_isLast : n == this.d_curRow;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_INCORRECT_CURSOR_TYPE);
    }

    @Override
    public synchronized boolean relative(int n, boolean bl) throws SQLException {
        if (n != 1 || !bl) {
            throw new SQLException(LocalStrings.ERR_SQL_INCORRECT_CURSOR_TYPE);
        }
        if (this.d_curRow == Integer.MIN_VALUE) {
            this.d_curRow = 1;
            if (this.d_bufPos == this.d_bufCount - 1) {
                this.doFetch();
            }
            return true;
        }
        if (this.d_bufPos + 1 < this.d_bufCount) {
            ++this.d_bufPos;
            ++this.d_curRow;
            if (this.d_bufPos == this.d_bufCount - 1) {
                this.doFetch();
            }
            return true;
        }
        this.d_isLast = false;
        if (this.d_curRow != 0) {
            this.d_curRow = Integer.MAX_VALUE;
        }
        return false;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public short getRowStatus() throws SQLException {
        return this.validRow() ? (short)0 : 3;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (n < 1 || n > this.d_cis.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NUM, "S1002", 0);
        }
        return this.validRow() ? this.d_fetchBuf[this.d_bufPos][n - 1] : null;
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void readFrom(LNAResponse lNAResponse) throws IOException {
        short s = lNAResponse.readShort();
        short s2 = lNAResponse.readShort();
        int n = lNAResponse.readInt();
        lNAResponse.readInt();
        if (s == -16) {
            this.d_eof = true;
        }
        if (!this.d_eof && s2 <= 0) {
            this.d_eof = true;
            this.d_isDisabled = true;
        }
        if (s2 > 0) {
            int n2;
            int n3 = this.d_cis.getCount();
            int n4 = n2 = this.d_curFetchCol > 0 ? n3 - this.d_curFetchCol : 0;
            if (n2 > s2) {
                n2 = s2;
            }
            int n5 = s2 - n2;
            int n6 = n5 / n3;
            int n7 = n5 % n3;
            int n8 = n6 + (n7 > 0 ? 1 : 0);
            this.checkBuffers(n8);
            ArrayColumnBuffer arrayColumnBuffer = new ArrayColumnBuffer();
            for (int i = 0; i < n3; ++i) {
                int n9 = this.d_curFetchCol > 0 && i >= this.d_curFetchCol && i < this.d_curFetchCol + n2 ? 1 : 0;
                int n10 = n9 + n6 + (i < n7 ? 1 : 0);
                arrayColumnBuffer.readFrom(lNAResponse, this.d_cis.getItem(i), n10);
                for (int j = 0; j < n10; ++j) {
                    this.d_fetchBuf[j + 1 - n9][i] = arrayColumnBuffer.getObject(j);
                }
            }
            this.d_curFetchCol = n7;
            this.d_bufCount = n8 + 1;
        }
    }

    @Override
    public void readFrom(LNAResponse lNAResponse, ColumnInfoSet columnInfoSet) throws IOException {
        if (!this.d_isClosed) {
            throw new IllegalStateException();
        }
        this.d_cis = columnInfoSet;
        this.d_bufCount = 1;
        this.d_bufPos = 1;
        this.readFrom(lNAResponse);
    }

    private boolean validRow() {
        return this.d_curRow >= 1 && this.d_curRow < Integer.MAX_VALUE;
    }

    private void doFetch() throws SQLException {
        if (this.d_eof) {
            this.d_isLast = true;
        } else {
            if (this.d_fetchBuf != null && this.d_bufPos == this.d_bufCount - 1) {
                System.arraycopy(this.d_fetchBuf[this.d_bufPos], 0, this.d_fetchBuf[0], 0, this.d_cis.getCount());
                this.d_bufPos = 0;
            } else {
                this.d_bufPos = 1;
            }
            this.d_bufCount = 1;
            while (this.d_bufCount == 1) {
                int n = this.d_curFetchCol;
                this.d_lnaStmt.arrayFetch(this.d_cis, this);
                if (n != this.d_curFetchCol) continue;
                break;
            }
            if (this.d_bufCount == 1 && this.d_curFetchCol > 0) {
                throw new SQLException(LocalStrings.ERR_SQL_INCOMPLETE_FETCH, "08S01", 0);
            }
            this.d_isLast = this.d_bufCount == 1;
        }
    }

    private void checkBuffers(int n) {
        int n2 = n + 1;
        if (this.d_fetchBuf == null || this.d_fetchBuf.length != n2) {
            Object[] objectArray = this.d_fetchBuf != null ? this.d_fetchBuf[0] : null;
            this.d_fetchBuf = new Object[n2][this.d_cis.getCount()];
            if (objectArray != null) {
                this.d_fetchBuf[0] = objectArray;
            }
        }
    }

    private void freeBuffers() {
        this.d_fetchBuf = null;
    }
}

