/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.Debug;
import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.ColumnInfo;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.FetchReader;
import com.pervasive.jdbc.lna.LNAConstants;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.LNAStatement;
import com.pervasive.jdbc.lna.LongDataInputStream;
import com.pervasive.jdbc.lna.ParamInfoSet;
import com.pervasive.jdbc.lna.ResultCache;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public abstract class AbstractScrollableCache
implements ResultCache,
FetchReader {
    protected static final int MAX_FETCH_SIZE = 1000;
    protected static final int DEFAULT_FETCH_SIZE = 10;
    protected static final int BUF_START = 0;
    protected LNAStatement d_lnaStmt;
    protected ColumnInfoSet d_cis;
    protected boolean d_isClosed;
    protected int d_fetchSize;
    protected Object[][] d_fetchBuf;
    protected short[] d_rowStats;
    protected int d_bufPos;
    protected int d_bufCount;
    protected int d_curRow;
    protected InputStream d_curStream;
    protected boolean d_updateable;
    protected int[] d_rowBookmarks;
    protected int d_nextFetchSize;
    private int[] d_tmpBookmarks;
    protected int d_overlapOffset;
    protected boolean d_bufferValid;
    protected Object[] d_insertBuf;
    protected Object[] d_updateBuf;
    protected int d_curBkmk = -1;
    protected boolean[] d_colStats;
    private boolean d_insertComplete;

    public AbstractScrollableCache(LNAStatement lNAStatement, ColumnInfoSet columnInfoSet, boolean bl) {
        this.d_lnaStmt = lNAStatement;
        this.d_cis = columnInfoSet;
        this.d_isClosed = true;
        this.d_fetchSize = this.d_lnaStmt.getStmtOpts().getRowSetSize();
        this.d_updateable = bl;
        this.d_rowStats = new short[this.d_fetchSize];
    }

    @Override
    public abstract void open() throws SQLException;

    @Override
    public synchronized void close() throws SQLException {
        if (!this.d_isClosed) {
            this.d_isClosed = true;
            this.freeBuffers();
            this.d_curRow = 0;
            this.d_lnaStmt.freeStmt((short)0);
        }
    }

    @Override
    public final boolean isClosed() {
        return this.d_isClosed;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.d_nextFetchSize;
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        if (n <= 0) {
            n = 10;
        } else if (n == 1) {
            n = 2;
        } else if (n > 1000) {
            n = 1000;
        }
        this.d_lnaStmt.getStmtOpts().setRowSetSize(n);
        this.d_nextFetchSize = n;
    }

    protected final void checkRowError() throws SQLException {
        if (this.d_rowStats[this.d_bufPos] == 5) {
            SQLException sQLException = this.d_lnaStmt.getErrors(false);
            throw sQLException;
        }
    }

    protected final boolean checkRowError(boolean bl) throws SQLException {
        if (bl) {
            this.checkRowError();
        }
        return bl;
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_OP_NOT_SUPPORTED);
    }

    @Override
    public boolean isRow(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean relative(int n, boolean bl) throws SQLException {
        return false;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (!this.d_updateable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        this.cancelInsert();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (!this.d_updateable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (this.d_insertBuf == null) {
            this.d_updateBuf = null;
            this.d_colStats = new boolean[this.d_cis.getCount()];
            this.d_insertBuf = new Object[this.d_cis.getCount()];
            this.d_insertComplete = false;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.d_updateable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (this.d_insertBuf == null) {
            throw new SQLException(LocalStrings.ERR_SQL_NOT_ON_INSERT_ROW);
        }
        ParamInfoSet paramInfoSet = this.createDaeParamInfoSet(this.d_insertBuf, this.d_colStats);
        this.d_rowStats[this.d_bufPos] = this.d_lnaStmt.setPos((short)1, (short)4, (short)0, this.d_cis, paramInfoSet, this.d_rowStats, this.d_insertBuf, this.d_colStats);
        this.d_insertComplete = true;
    }

    @Override
    public void updateRow() throws SQLException {
        if (!this.d_updateable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (!this.validRow()) {
            return;
        }
        if (this.d_insertBuf != null) {
            throw new SQLException(LocalStrings.ERR_SQL_NOT_ON_CURRENT_ROW);
        }
        if (this.d_updateBuf == null) {
            return;
        }
        ParamInfoSet paramInfoSet = this.createDaeParamInfoSet(this.d_updateBuf, this.d_colStats);
        this.d_rowStats[this.d_bufPos] = this.d_lnaStmt.setPos((short)(this.d_bufPos + 1), (short)2, (short)0, this.d_cis, paramInfoSet, this.d_rowStats, this.d_updateBuf, this.d_colStats);
        if (this.d_rowStats[this.d_bufPos] == 0 || this.d_rowStats[this.d_bufPos] == 2) {
            this.d_fetchBuf[this.d_bufPos] = this.d_updateBuf;
            this.refreshRow();
        }
        this.d_updateBuf = null;
        this.d_colStats = null;
    }

    @Override
    public void deleteRow() throws SQLException {
        if (!this.d_updateable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (!this.validRow()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_CURRENT_POSITION);
        }
        if (this.d_insertBuf != null) {
            throw new SQLException(LocalStrings.ERR_SQL_NOT_ON_CURRENT_ROW);
        }
        if (this.d_bufCount == 0) {
            return;
        }
        this.d_rowStats[this.d_bufPos] = this.d_lnaStmt.setPos((short)(this.d_bufPos + 1), (short)3, (short)0, this.d_cis, null, this.d_rowStats, null, null);
    }

    @Override
    public void refreshRow() throws SQLException {
        if (!this.d_updateable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (this.d_insertBuf != null) {
            throw new SQLException(LocalStrings.ERR_SQL_NOT_ON_CURRENT_ROW);
        }
        if (!this.validRow()) {
            return;
        }
        if (this.d_bufCount == 0) {
            return;
        }
        this.d_rowStats[this.d_bufPos] = this.d_lnaStmt.setPos((short)(this.d_bufPos + 1), (short)1, (short)0, this.d_cis, null, this.d_rowStats, null, null);
        this.d_updateBuf = null;
        this.d_colStats = null;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (!this.d_updateable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (this.d_insertBuf != null) {
            throw new SQLException(LocalStrings.ERR_SQL_NOT_ON_CURRENT_ROW);
        }
        this.d_updateBuf = null;
        this.d_colStats = null;
    }

    @Override
    public abstract short getRowStatus() throws SQLException;

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        if (!this.d_updateable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (n < 1 || n > this.d_cis.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NUM, "S1002", 0);
        }
        if (this.d_insertBuf == null) {
            if (!this.validRow()) {
                return;
            }
            if (this.d_rowStats[this.d_bufPos] == 1) {
                return;
            }
            if (this.d_updateBuf == null) {
                int n2 = this.d_cis.getCount();
                this.d_updateBuf = new Object[n2];
                this.d_colStats = new boolean[n2];
                for (int i = 0; i < n2; ++i) {
                    this.d_updateBuf[i] = this.d_fetchBuf[this.d_bufPos][i];
                }
            }
            this.d_updateBuf[n - 1] = object;
            this.d_colStats[n - 1] = true;
        } else {
            if (this.d_insertComplete) {
                this.d_insertComplete = false;
                for (int i = 0; i < this.d_insertBuf.length; ++i) {
                    this.d_insertBuf[i] = null;
                }
            }
            this.d_insertBuf[n - 1] = object;
            this.d_colStats[n - 1] = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObject(int n) throws SQLException {
        if (n < 1) throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NUM, "S1002", 0);
        if (n > this.d_cis.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NUM, "S1002", 0);
        }
        Object object = null;
        if (this.d_insertBuf != null) return this.d_insertBuf[n - 1];
        if (this.d_updateBuf != null) return this.d_updateBuf[n - 1];
        if (!this.validRow()) return null;
        this.closeStream();
        object = this.d_fetchBuf[this.d_bufPos][n - 1];
        if (object != null) return object;
        ColumnInfo columnInfo = this.d_cis.getItem(n - 1);
        if (!columnInfo.hasLongData()) return object;
        this.setPosition(this.d_bufPos + 1);
        this.d_curStream = new LongDataInputStream(this.d_lnaStmt, (short)n, columnInfo.getBindType());
        object = this.d_curStream;
        try {
            if (!((LongDataInputStream)this.d_curStream).isNull()) return object;
            return null;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString(), iOException);
        }
    }

    @Override
    public void readFrom(LNAResponse lNAResponse) throws IOException {
        int n;
        int n2;
        this.d_overlapOffset = 0;
        this.d_bufferValid = true;
        int n3 = this.d_cis.getCount();
        int n4 = lNAResponse.readInt();
        int n5 = lNAResponse.readInt();
        int n6 = lNAResponse.readInt();
        if (n4 == 0 || n3 == 0) {
            this.d_bufferValid = false;
            return;
        }
        this.d_bufCount = 0;
        if (this.d_tmpBookmarks == null || this.d_tmpBookmarks.length != this.d_nextFetchSize) {
            this.d_tmpBookmarks = new int[this.d_nextFetchSize];
        }
        if (this.d_rowStats == null || this.d_rowStats.length != this.d_nextFetchSize) {
            this.d_rowStats = new short[this.d_nextFetchSize];
        }
        if (this.d_fetchBuf == null || this.d_fetchBuf.length != this.d_nextFetchSize || this.d_fetchBuf[0].length != n3) {
            this.d_fetchBuf = new Object[this.d_nextFetchSize][n3];
        }
        for (n2 = 0; n2 < this.d_nextFetchSize; ++n2) {
            this.d_rowStats[n2] = lNAResponse.readShort();
        }
        if (n4 > 0) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.d_rowStats[n2] != 3 && this.d_rowStats[n2] != 5) {
                    lNAResponse.readInt();
                    this.d_tmpBookmarks[n2] = lNAResponse.readInt();
                    for (n = 0; n < n3; ++n) {
                        this.d_fetchBuf[n2][n] = this.d_cis.getItem(n).readValueFrom(lNAResponse);
                    }
                    ++this.d_bufCount;
                    continue;
                }
                for (n = 0; n < n3; ++n) {
                    this.d_fetchBuf[n2][n] = null;
                }
                if (this.d_rowStats[n2] != 5) continue;
                ++this.d_bufCount;
            }
        }
        if ((n2 = (int)lNAResponse.getReturnCode()) == 1 && this.d_rowBookmarks != null) {
            n = 0;
            int n7 = 0;
            for (int i = 0; i < this.d_rowBookmarks.length && n == 0; ++i) {
                n7 = n4 - 1;
                while (n7 >= 0 && n == 0) {
                    if (this.d_rowBookmarks[i] == this.d_tmpBookmarks[n7]) {
                        n = 1;
                        continue;
                    }
                    --n7;
                }
            }
            if (n != 0) {
                this.d_overlapOffset = n4 - n7;
            }
        }
        int[] nArray = this.d_rowBookmarks;
        this.d_rowBookmarks = this.d_tmpBookmarks;
        this.d_tmpBookmarks = nArray;
        this.d_fetchSize = this.d_nextFetchSize;
    }

    @Override
    public void readFrom(LNAResponse lNAResponse, ColumnInfoSet columnInfoSet) throws IOException {
        throw new IOException(LocalStrings.ERR_NOT_IMPL);
    }

    private void printRowStatus() {
        block8: for (int i = 0; i < this.d_fetchSize; ++i) {
            switch (this.d_rowStats[i]) {
                case 0: {
                    Debug.println("[" + this.d_rowBookmarks[i] + "]" + "SUCCESS:" + (Integer)this.d_fetchBuf[i][0]);
                    continue block8;
                }
                case 3: {
                    Debug.println("NOROW");
                    continue block8;
                }
                case 1: {
                    Debug.println("DELETED");
                    continue block8;
                }
                case 2: {
                    Debug.println("UPDATED");
                    continue block8;
                }
                case 4: {
                    Debug.println("ADDED");
                    continue block8;
                }
                case 5: {
                    Debug.println("ERROR");
                }
            }
        }
    }

    protected abstract void setPosition(int var1) throws SQLException;

    protected boolean validRow() {
        return this.d_curRow >= 1 && this.d_curRow < Integer.MAX_VALUE || this.d_curRow <= -1 && this.d_curRow > Integer.MIN_VALUE;
    }

    protected void cancelInsert() {
        this.d_insertBuf = null;
    }

    private void closeStream() {
        if (this.d_curStream != null) {
            try {
                this.d_curStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.d_curStream = null;
        }
    }

    public ParamInfoSet createDaeParamInfoSet(Object[] objectArray, boolean[] blArray) {
        ParamInfoSet paramInfoSet = new ParamInfoSet();
        ColumnInfo columnInfo = null;
        Object var5_5 = null;
        short s = 0;
        for (int i = 0; i < this.d_cis.getCount(); ++i) {
            columnInfo = this.d_cis.getItem(i);
            if (!columnInfo.hasLongData() || objectArray[i] == null || blArray == null || !blArray[i]) continue;
            s = (short)(s + 1);
            paramInfoSet.addParamDesc(columnInfo, s, (short)1, objectArray[i], LNAConstants.SQL_LEN_DATA_AT_EXEC(24576));
        }
        return paramInfoSet;
    }

    private void freeBuffers() {
        this.d_fetchBuf = null;
        this.d_rowStats = null;
        this.d_rowBookmarks = null;
        this.d_tmpBookmarks = null;
        this.d_insertBuf = null;
        this.d_updateBuf = null;
        this.d_colStats = null;
    }
}

