/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.util.Date;
import java.util.GregorianCalendar;
import pervasive.database.MessageCatalog;

public class Timestamp
extends Date {
    static final int DAYS_IN_YEAR = 365;
    static final int LEAP_YEAR_4 = 4;
    static final int LEAP_YEAR_100 = 100;
    static final int LEAP_YEAR_400 = 400;
    static final long MILLION_10 = 10000000L;
    static final long MONTHS_IN_YEAR = 12L;
    static final int MAX_TIMESTAMP_YEAR = 9999;
    static final int MAX_FRACTIONAL_DIGITS = 7;
    static int[] aDayOfMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int _septa;
    private GregorianCalendar m_cal = new GregorianCalendar();

    public Timestamp() {
        this(true);
    }

    public Timestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.m_cal.set(n + 1900, n2, n3, n4, n5, n6);
        this.m_cal.set(14, 0);
        super.setTime(this.m_cal.getTime().getTime());
        this._septa = n7;
    }

    public Timestamp(long l) {
        super(l);
        this.setTime(l);
    }

    Timestamp(boolean bl) {
        super(0L);
        if (!bl) {
            return;
        }
        this.setTime(System.currentTimeMillis());
    }

    public static Timestamp valueOf(String string) {
        java.sql.Timestamp timestamp = null;
        try {
            timestamp = java.sql.Timestamp.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(MessageCatalog.getTimestampFormatErrorMsg());
        }
        int n = string.length();
        if (n - string.lastIndexOf(".", n) > 8) {
            throw new IllegalArgumentException(MessageCatalog.getTimestampFormatErrorMsg());
        }
        Timestamp timestamp2 = new Timestamp(timestamp.getTime());
        timestamp2.setSepta(timestamp.getNanos() / 100);
        return timestamp2;
    }

    @Override
    public String toString() {
        java.sql.Timestamp timestamp = new java.sql.Timestamp(super.getTime());
        timestamp.setNanos(this._septa * 100);
        return timestamp.toString();
    }

    @Override
    public void setTime(long l) {
        long l2 = l % 1000L;
        super.setTime(l - l2);
        this._septa = (int)(l2 * 10000L);
    }

    @Override
    public long getTime() {
        return super.getTime() + (long)(this._septa / 10000);
    }

    public int getSepta() {
        return this._septa;
    }

    public void setSepta(int n) {
        this._septa = n;
    }

    public boolean equals(Timestamp timestamp) {
        if (this._septa != timestamp.getSepta()) {
            return false;
        }
        return super.equals(timestamp);
    }

    public boolean before(Timestamp timestamp) {
        if (super.before(timestamp)) {
            return true;
        }
        if (super.after(timestamp)) {
            return false;
        }
        return this._septa < timestamp.getSepta();
    }

    public boolean after(Timestamp timestamp) {
        if (super.after(timestamp)) {
            return true;
        }
        if (super.before(timestamp)) {
            return false;
        }
        return this._septa > timestamp.getSepta();
    }

    long septaValue() {
        return this.getSeptaTime(7);
    }

    long septaValue(int n) {
        return this.getSeptaTime(n);
    }

    static Timestamp valueOf(long l) {
        Timestamp timestamp = new Timestamp(false);
        timestamp.setSeptaTime(l);
        return timestamp;
    }

    private long getSeptaTime(int n) {
        this.m_cal.setTime(this);
        long l = this.getNumDays(this.m_cal.get(1), this.m_cal.get(2) + 1, this.m_cal.get(5));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        long l2 = ((long)(this.m_cal.get(13) + (this.m_cal.get(12) + 60 * this.m_cal.get(11)) * 60) + l * 24L * 60L * 60L - (long)((this.m_cal.get(15) + gregorianCalendar.get(16)) / 1000)) * 10000000L;
        l2 += (long)this._septa;
        if (n < 7) {
            l2 = this.setPrecision(l2, n);
        }
        return l2;
    }

    private void setSeptaTime(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        long l2 = l / 10000000L + (long)((this.m_cal.get(15) + gregorianCalendar.get(16)) / 1000);
        long l3 = l2 % 60L;
        long l4 = l2 / 60L;
        long l5 = l4 % 60L;
        long l6 = l4 / 60L;
        long l7 = l6 % 24L;
        long l8 = l6 / 24L;
        int n = (int)(l8 / 366L);
        n = n < 1 ? 1 : n;
        int n2 = (int)(l8 - (long)((n - 1) * 365 + (n - 1) / 4 - (n - 1) / 100 + (n - 1) / 400));
        int n3 = 3659634;
        int n4 = 0;
        n4 = n;
        while (n2 <= n3 && n2 >= 366) {
            n3 = n2;
            n2 = (int)(l8 - (long)((n4 - 1) * 365 + (n4 - 1) / 4 - (n4 - 1) / 100 + (n4 - 1) / 400));
            ++n4;
        }
        int n5 = n4 > 1 ? n4 - 1 : n4;
        int n6 = n2;
        int n7 = 1;
        int n8 = 1;
        Timestamp.aDayOfMonth[1] = this.isLeapYear(n5) ? 29 : 28;
        int n9 = 0;
        while ((long)n9 < 12L && aDayOfMonth[n9] < n6) {
            n6 -= aDayOfMonth[n9];
            ++n9;
        }
        n7 = n9 + 1;
        if (n6 != 0 && n6 == aDayOfMonth[n7 - 1]) {
            if ((long)n7 == 12L) {
                ++n5;
                n7 = 1;
            } else {
                ++n7;
            }
            n6 = 0;
        }
        n8 = n6 + 1;
        this.m_cal.set(n5, n7 - 1, n8, (int)l7, (int)l5, (int)l3);
        this.m_cal.set(14, 0);
        super.setTime(this.m_cal.getTime().getTime());
        this._septa = (int)(l % 10000000L);
    }

    private long getNumDays(int n, int n2, int n3) {
        int n4;
        long l = 0L;
        if (n > 1) {
            n4 = n - 1;
            l = n4 * 365 + n4 / 4 - n4 / 100 + n4 / 400;
        }
        l += (long)(n3 - 1);
        Timestamp.aDayOfMonth[1] = this.isLeapYear(n) ? 29 : 28;
        for (n4 = 0; n4 < n2 - 1; ++n4) {
            l += (long)aDayOfMonth[n4];
        }
        return l;
    }

    private long setPrecision(long l, int n) {
        long l2 = 1L;
        int n2 = 7 - n;
        for (int i = 0; i < n2; ++i) {
            l2 *= 10L;
        }
        l += l2 / 2L;
        l -= l % l2;
        return l;
    }

    boolean isLeapYear(int n) {
        boolean bl = false;
        if (n % 4 == 0 && (n % 100 != 0 || n % 400 == 0)) {
            bl = true;
        }
        return bl;
    }
}

