/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.util.Vector;
import pervasive.database.Consts;
import pervasive.database.DBURI;
import pervasive.database.Database;
import pervasive.database.Driver;
import pervasive.database.IBTRV;
import pervasive.database.JNIBTRV;
import pervasive.database.MessageCatalog;
import pervasive.database.PsqlException;
import pervasive.database.PsqlInvalidObjectException;
import pervasive.database.PsqlOperationException;
import pervasive.database.SCursor;

public final class Session
implements Consts {
    private static short m_taskID = (short)256;
    private Driver m_parent;
    int m_transtype;
    int m_translevel = 0;
    int m_impliedLock = 0;
    Vector m_databases = new Vector();
    private boolean m_objClosed = false;
    private IBTRV m_btrv = null;
    private SCursor m_cursor = null;
    private byte[] m_clientID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 67, 0, 0};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Session(Driver driver) {
        this.m_parent = driver;
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            this.m_clientID[14] = (byte)(m_taskID / 256);
            this.m_clientID[15] = (byte)(m_taskID % 256);
            m_taskID = (short)(m_taskID + 1);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String[] getDatabaseNames(String string) throws PsqlException {
        if (this.m_cursor == null) {
            this.createInternalCursor();
        }
        return this.m_btrv.getDatabaseNames(string);
    }

    public Database connectToDatabase() throws PsqlException {
        return this.connectToDatabase("btrv:");
    }

    public Database connectToDatabase(String string, String string2, String string3, String string4) throws PsqlException {
        return this.connectToDatabase(new DBURI(string3, string, string2, string4, null, null, null, null).toString());
    }

    public Database connectToDatabase(String string) throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        if (this.m_cursor == null) {
            this.createInternalCursor();
        }
        Database database = new Database(this, string);
        this.m_databases.addElement(database);
        return database;
    }

    public void startTransaction(int n) throws PsqlException {
        this.startTransaction(n, 0);
    }

    public void startTransaction(int n, int n2) throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        int n3 = this.m_databases.size();
        for (int i = 0; i < n3; ++i) {
            Database database = (Database)this.m_databases.elementAt(i);
            try {
                database.beginTransaction(n + n2);
                continue;
            }
            catch (PsqlException psqlException) {
                if (psqlException instanceof PsqlOperationException && ((PsqlOperationException)psqlException).getErrorCode() == 37 && i > 0) continue;
                for (int j = 0; j < i; ++j) {
                    try {
                        ((Database)this.m_databases.elementAt(j)).abortTransaction();
                        continue;
                    }
                    catch (PsqlOperationException psqlOperationException) {
                        // empty catch block
                    }
                }
                throw psqlException;
            }
        }
    }

    public void abortTransaction() throws PsqlException {
        this.abortTransaction(1);
    }

    public void abortTransaction(int n) throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        PsqlException psqlException = null;
        int n2 = this.m_databases.size();
        for (int i = 0; i < n2; ++i) {
            Database database = (Database)this.m_databases.elementAt(i);
            try {
                database.abortTransaction();
                continue;
            }
            catch (PsqlException psqlException2) {
                if (psqlException2 instanceof PsqlOperationException && ((PsqlOperationException)psqlException2).getErrorCode() == 39 && i != 0) continue;
                psqlException = psqlException2;
            }
        }
        if (psqlException != null) {
            throw psqlException;
        }
    }

    public void commitTransaction() throws PsqlException {
        this.commitTransaction(1);
    }

    public void commitTransaction(int n) throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        Object var2_2 = null;
        int n2 = this.m_databases.size();
        for (int i = 0; i < n2; ++i) {
            Database database = (Database)this.m_databases.elementAt(i);
            try {
                database.endTransaction();
                continue;
            }
            catch (PsqlException psqlException) {
                if (psqlException instanceof PsqlOperationException && ((PsqlOperationException)psqlException).getErrorCode() == 39 && i > 0) continue;
                ++i;
                while (i < n2) {
                    try {
                        ((Database)this.m_databases.elementAt(i)).abortTransaction();
                    }
                    catch (PsqlOperationException psqlOperationException) {
                        // empty catch block
                    }
                    ++i;
                }
                throw psqlException;
            }
        }
    }

    public void close() {
        if (this.m_objClosed) {
            return;
        }
        try {
            this.abortTransaction(-1);
        }
        catch (PsqlException psqlException) {
            // empty catch block
        }
        for (int i = this.m_databases.size() - 1; i >= 0; --i) {
            ((Database)this.m_databases.lastElement()).close();
        }
        try {
            if (this.m_cursor != null) {
                this.m_cursor.BTRV(28, 0);
                this.m_btrv.close();
            }
        }
        catch (PsqlException psqlException) {
            // empty catch block
        }
        this.m_parent.childClosed(this);
        this.m_objClosed = true;
    }

    void childClosed(Database database) {
        this.m_databases.removeElement(database);
    }

    byte[] getClientID() {
        return this.m_clientID;
    }

    private void createInternalCursor() throws PsqlException {
        this.m_btrv = new JNIBTRV();
        this.m_cursor = new SCursor(this, this.m_btrv, 100, 255, "US-ASCII");
    }
}

