/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.AbstractScrollableCache;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.ForwardReadResultCache;
import com.pervasive.jdbc.lna.LNAConnection;
import com.pervasive.jdbc.lna.LNAStatement;
import com.pervasive.jdbc.lna.ParamDescSet;
import com.pervasive.jdbc.lna.ParamInfoSet;
import java.sql.SQLException;

public class InsensitiveResultCache
extends AbstractScrollableCache {
    protected int d_resultSetSize;
    protected int d_fetchDir;
    protected int d_lowIndex;
    protected int d_highIndex;
    private String d_sql;
    private String d_sql2;

    public InsensitiveResultCache(LNAStatement lNAStatement, ColumnInfoSet columnInfoSet, boolean bl, int n, String string) {
        super(lNAStatement, columnInfoSet, bl);
        this.d_fetchDir = n;
        this.d_sql2 = string;
        this.d_sql = string.trim().toUpperCase();
        this.d_resultSetSize = -1;
    }

    @Override
    public synchronized void open() throws SQLException {
        if (this.d_isClosed) {
            this.d_isClosed = false;
            this.d_nextFetchSize = this.d_fetchSize;
            this.fetchFirst();
            this.d_curRow = this.d_bufferValid ? Integer.MIN_VALUE : 0;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.d_fetchDir;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.d_fetchDir = n;
    }

    @Override
    public short getRowStatus() throws SQLException {
        return this.validRow() ? (short)0 : 3;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.d_curRow >= 1) {
            return this.d_curRow;
        }
        if (this.d_curRow == Integer.MIN_VALUE) {
            return 0;
        }
        if (this.d_curRow <= -1) {
            if (this.d_resultSetSize == -1) {
                this.d_resultSetSize = this.getResultSetCount();
            }
            return this.d_resultSetSize + this.d_curRow + 1;
        }
        return 0;
    }

    @Override
    public boolean isRow(int n) throws SQLException {
        if (n == Integer.MIN_VALUE || n == Integer.MAX_VALUE || n == 0) {
            return this.d_curRow == n;
        }
        if (n == 1 && this.d_curRow < 0) {
            if (this.d_curRow == -1 || this.d_curRow == Integer.MAX_VALUE || this.d_curRow == Integer.MIN_VALUE) {
                return false;
            }
            if (this.d_bufPos == 0 && this.d_curRow == this.d_lowIndex) {
                int n2 = this.d_rowBookmarks[0];
                this.fetchAbsolute(this.d_lowIndex - 1, false, false);
                if (n2 == this.d_rowBookmarks[0]) {
                    this.d_bufPos = 0;
                    this.d_curRow = 1;
                    return true;
                }
                --this.d_lowIndex;
                this.d_highIndex = this.d_lowIndex + this.d_bufCount - 1;
                ++this.d_bufPos;
                return false;
            }
        }
        if (n == -1 && this.d_curRow > 0) {
            if (this.d_curRow == 1 || this.d_curRow == Integer.MAX_VALUE || this.d_curRow == Integer.MIN_VALUE) {
                return false;
            }
            if (this.d_bufCount == this.d_fetchSize && this.d_curRow == this.d_highIndex) {
                this.fetchAbsolute(this.d_lowIndex + 1, false, false);
                ++this.d_lowIndex;
                this.d_highIndex = this.d_lowIndex + this.d_bufCount - 1;
                --this.d_bufPos;
                return this.d_bufCount == this.d_fetchSize ? false : this.d_bufPos == this.d_bufCount - 1;
            }
            return this.d_bufPos == this.d_bufCount - 1;
        }
        return this.d_curRow == n;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        if (this.d_curRow == 0) {
            return false;
        }
        if (this.d_curRow == n) {
            this.checkRowError();
            return true;
        }
        this.cancelInsert();
        int n2 = 0;
        boolean bl = false;
        switch (n) {
            case 1: {
                this.fetchFirst();
                bl = true;
                break;
            }
            case -1: {
                this.fetchLast();
                bl = true;
                break;
            }
            case -2147483648: {
                this.fetchFirst();
                if (this.d_curRow != 0) {
                    this.d_curRow = Integer.MIN_VALUE;
                }
                return false;
            }
            case 0x7FFFFFFF: {
                this.fetchLast();
                if (this.d_curRow != 0) {
                    this.d_curRow = Integer.MAX_VALUE;
                }
                return false;
            }
            default: {
                boolean bl2 = this.validRow();
                boolean bl3 = this.rowInBuffer(n);
                int n3 = n2 = bl2 ? n - this.d_curRow : 0;
                if (bl3) {
                    if (bl2) {
                        this.d_curRow = n;
                        this.d_bufPos += n2;
                        bl = true;
                        break;
                    }
                    this.d_curRow = n;
                    this.d_bufPos = n - this.d_lowIndex;
                    bl = true;
                    break;
                }
                bl = this.fetchAbsolute(n, true, true);
            }
        }
        if (bl) {
            this.checkRowError();
        }
        return bl;
    }

    @Override
    public boolean relative(int n, boolean bl) throws SQLException {
        this.cancelInsert();
        if (this.d_curRow == 0 && bl) {
            return false;
        }
        if (this.d_curRow == Integer.MIN_VALUE) {
            if (n == 1 && bl) {
                return this.checkRowError(this.absolute(1));
            }
            if (n == -1 && bl) {
                return false;
            }
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_CURRENT_POSITION);
        }
        if (this.d_curRow == Integer.MAX_VALUE) {
            if (n == -1 && bl) {
                return this.checkRowError(this.absolute(-1));
            }
            if (n == 1 && bl) {
                return false;
            }
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_CURRENT_POSITION);
        }
        if (!this.validRow()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_CURRENT_POSITION);
        }
        int n2 = 0;
        if (this.movedToInvalidRow(n)) {
            return false;
        }
        int n3 = this.d_curRow + n;
        if (this.rowInBuffer(n3)) {
            this.d_curRow = n3;
            this.d_bufPos += n;
            return this.checkRowError(true);
        }
        n2 = this.localOffset(n3);
        if (n2 != -1) {
            if (n3 > this.d_highIndex) {
                return this.checkRowError(this.fetchNext(n2, n3));
            }
            return this.checkRowError(this.fetchPrior(n2, n3, n));
        }
        return this.checkRowError(this.fetchAbsolute(n3, true, true));
    }

    private boolean movedToInvalidRow(int n) {
        if (this.d_curRow >= 1) {
            if (this.d_curRow + n < 1) {
                this.d_curRow = Integer.MIN_VALUE;
                return true;
            }
        } else if (this.d_curRow <= -1 && this.d_curRow + n > -1) {
            this.d_curRow = Integer.MAX_VALUE;
            return true;
        }
        return false;
    }

    private boolean rowInBuffer(int n) {
        if (this.d_lowIndex >= 1 && n < 1 || this.d_lowIndex <= -1 && n > -1) {
            return false;
        }
        return n >= this.d_lowIndex && n <= this.d_highIndex;
    }

    private int localOffset(int n) {
        if (n >= this.d_lowIndex - this.d_nextFetchSize && n < this.d_lowIndex) {
            return n - (this.d_lowIndex - this.d_nextFetchSize);
        }
        if (n > this.d_highIndex && n <= this.d_highIndex + this.d_nextFetchSize) {
            return n - (this.d_highIndex + 1);
        }
        return -1;
    }

    private boolean fetchAbsolute(int n, boolean bl, boolean bl2) throws SQLException {
        short s = 0;
        int n2 = n;
        boolean bl3 = true;
        this.d_fetchSize = this.d_nextFetchSize;
        if (this.d_fetchDir == 1001 && bl2) {
            n2 = n - this.d_fetchSize + 1;
            bl3 = false;
            if (n >= 1 && n2 < 1 || n <= -1 && n2 > -1) {
                n2 = n;
                bl3 = true;
            }
            s = this.d_lnaStmt.extendedFetch((short)5, n2, this.d_cis, this);
            if (!this.d_bufferValid || s == 1) {
                n2 = n;
                bl3 = s == 1;
                s = this.d_lnaStmt.extendedFetch((short)5, n2, this.d_cis, this);
            }
        } else {
            s = this.d_lnaStmt.extendedFetch((short)5, n2, this.d_cis, this);
        }
        if (!this.d_bufferValid) {
            if (n2 > 1) {
                this.d_curRow = Integer.MAX_VALUE;
            } else if (n2 < -1) {
                this.d_curRow = Integer.MIN_VALUE;
            }
            return false;
        }
        if (s == 1) {
            this.d_bufPos = 0;
            this.d_lowIndex = 1;
            this.d_highIndex = this.d_bufCount;
            this.d_curRow = Integer.MIN_VALUE;
            return false;
        }
        if (bl) {
            this.d_lowIndex = n2;
            this.d_highIndex = n2 + this.d_bufCount - 1;
            if (!bl3) {
                this.d_bufPos = this.d_bufCount - 1;
                this.d_curRow = this.d_highIndex;
                if (n > this.d_highIndex) {
                    this.d_curRow = Integer.MAX_VALUE;
                    return false;
                }
            } else {
                this.d_bufPos = 0;
                this.d_curRow = n2;
            }
            return true;
        }
        return true;
    }

    private void fetchLast() throws SQLException {
        if (this.d_highIndex != -1) {
            this.d_lnaStmt.extendedFetch((short)3, 0, this.d_cis, this);
            this.d_lowIndex = -this.d_bufCount;
            this.d_highIndex = -1;
        }
        this.d_bufPos = this.d_bufCount - 1;
        this.d_curRow = this.d_lowIndex == 0 ? 0 : -1;
    }

    private void fetchFirst() throws SQLException {
        if (this.d_lowIndex != 1) {
            this.d_lnaStmt.extendedFetch((short)2, 0, this.d_cis, this);
            this.d_lowIndex = 1;
            this.d_highIndex = this.d_bufCount;
        }
        this.d_bufPos = 0;
        this.d_curRow = this.d_highIndex == 0 ? 0 : 1;
    }

    private boolean fetchNext(int n, int n2) throws SQLException {
        boolean bl = true;
        if (this.d_fetchDir == 1001) {
            bl = this.fetchAbsolute(n2, true, true);
            return bl;
        }
        this.d_lnaStmt.extendedFetch((short)1, 0, this.d_cis, this);
        this.d_lowIndex = this.d_highIndex + 1;
        this.d_highIndex += this.d_bufCount;
        if (n >= this.d_bufCount || !this.d_bufferValid) {
            this.d_curRow = Integer.MAX_VALUE;
            return false;
        }
        this.d_curRow = n2;
        this.d_bufPos = n;
        return true;
    }

    private boolean fetchPrior(int n, int n2, int n3) throws SQLException {
        boolean bl = true;
        if (this.d_fetchDir == 1000) {
            bl = this.fetchAbsolute(n2, true, true);
            return bl;
        }
        short s = 0;
        int n4 = 0;
        n4 = this.d_lowIndex - this.d_nextFetchSize;
        if (this.d_lowIndex == 1) {
            this.d_curRow = Integer.MIN_VALUE;
            return false;
        }
        if (this.d_lowIndex > 1 && n4 < 1) {
            s = this.d_lnaStmt.extendedFetch((short)2, 0, this.d_cis, this);
            int n5 = this.d_lowIndex;
            this.d_lowIndex = 1;
            this.d_highIndex = this.d_bufCount;
            this.d_overlapOffset = this.d_highIndex - n5 + 1 + (this.d_fetchSize - this.d_bufCount);
        } else {
            s = this.d_lnaStmt.extendedFetch((short)5, n4, this.d_cis, this);
            if (s == 1) {
                this.d_lowIndex = 1;
                this.d_highIndex = this.d_bufCount;
            } else {
                this.d_highIndex = this.d_lowIndex - 1;
                this.d_lowIndex -= this.d_bufCount;
            }
        }
        if (n - this.d_overlapOffset >= this.d_bufCount || !this.d_bufferValid) {
            this.d_curRow = Integer.MIN_VALUE;
            return false;
        }
        this.d_curRow = n2;
        if (this.d_overlapOffset != 0) {
            this.d_bufPos = n - this.d_overlapOffset;
            this.d_curRow = this.d_bufPos + 1;
            if (this.d_bufPos < 0) {
                this.d_curRow = Integer.MIN_VALUE;
                return false;
            }
        } else {
            this.d_bufPos = n;
        }
        return true;
    }

    @Override
    protected void setPosition(int n) throws SQLException {
        if (!this.d_bufferValid) {
            this.fetchAbsolute(this.d_lowIndex, false, false);
        }
        this.d_lnaStmt.setPos((short)n, (short)0, (short)0, this.d_cis, null, this.d_rowStats, null, null);
    }

    private int getResultSetCount() {
        String string = "SELECT COUNT(*) FROM ( ";
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(this.d_sql2);
        int n = this.d_sql.lastIndexOf(" ORDER BY ");
        int n2 = this.d_sql.lastIndexOf(")");
        if (n != -1 && (n2 == -1 || n2 < n)) {
            stringBuffer.delete(n, stringBuffer.length());
        }
        string2 = stringBuffer.toString();
        string = string + string2 + " ) A";
        try {
            LNAConnection lNAConnection = this.d_lnaStmt.getLNAConnection();
            LNAStatement lNAStatement = lNAConnection.allocStmt();
            ParamInfoSet paramInfoSet = new ParamInfoSet();
            ColumnInfoSet columnInfoSet = new ColumnInfoSet();
            ParamDescSet paramDescSet = new ParamDescSet();
            lNAStatement.execDirect(string, paramInfoSet, columnInfoSet, paramDescSet);
            ForwardReadResultCache forwardReadResultCache = new ForwardReadResultCache(lNAStatement, columnInfoSet);
            forwardReadResultCache.open();
            forwardReadResultCache.relative(1, true);
            Integer n3 = (Integer)forwardReadResultCache.getObject(1);
            forwardReadResultCache.close();
            lNAStatement.close();
            return n3;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        if (!this.d_updateable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (!this.validRow()) {
            return;
        }
        if (this.d_insertBuf != null) {
            throw new SQLException(LocalStrings.ERR_SQL_NOT_ON_CURRENT_ROW);
        }
        if (this.d_updateBuf == null) {
            return;
        }
        ParamInfoSet paramInfoSet = this.createDaeParamInfoSet(this.d_updateBuf, this.d_colStats);
        this.d_rowStats[this.d_bufPos] = this.d_lnaStmt.setPos((short)(this.d_bufPos + 1), (short)2, (short)0, this.d_cis, paramInfoSet, this.d_rowStats, this.d_updateBuf, this.d_colStats);
        if (this.d_rowStats[this.d_bufPos] == 0 || this.d_rowStats[this.d_bufPos] == 2) {
            this.d_fetchBuf[this.d_bufPos] = this.d_updateBuf;
            this.d_rowStats[this.d_bufPos] = 0;
        }
        this.d_updateBuf = null;
        this.d_colStats = null;
    }
}

