#!/bin/sh

echo "+++++ Checking current user rights..."

if [ "$(id -u root)" = "$(id -u)" ] ; then
    :
else
    echo "ERROR: The current user id is not root (`id|awk '{print $1}'`)."
    exit 1
fi
echo

if [ "X$ACTIANZEN_ROOT" = "X" ] ; then
    ACTIANZEN_ROOT=/usr/local/actianzen
fi

##########################################################################
#  Note: Any changes to the files to be removed must be made to the 
#        corresponding Zen-Clients-Linux-Access.spec file %postun section. 
##########################################################################
echo "+++++ Removing Zen Client Access Files..."
rm -f $ACTIANZEN_ROOT/lib/lib*
rm -f $ACTIANZEN_ROOT/lib/pam*
rm -f $ACTIANZEN_ROOT/bin/psregsvr
rm -f $ACTIANZEN_ROOT/etc/clientaccess*

echo
echo "Uninstall has successfully completed."
echo



















